package com.example.configdemo.config;

import org.springframework.boot.context.event.ApplicationEnvironmentPreparedEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.MutablePropertySources;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ConfigurationLoggingApplicationListener implements ApplicationListener<ApplicationEnvironmentPreparedEvent> {

    @Override
    public void onApplicationEvent(ApplicationEnvironmentPreparedEvent event) {
        // 设置系统属性以确保正确的文件编码
        System.setProperty("file.encoding", "UTF-8");
        
        ConfigurableEnvironment environment = event.getEnvironment();
        MutablePropertySources propertySources = environment.getPropertySources();
        
        System.out.println("配置加载顺序（按优先级从高到低）:");
        
        // 正向遍历以显示从高优先级到低优先级
        // Spring中PropertySources是按优先级排序的，第一个元素优先级最高
        int index = 1;
        for (PropertySource<?> source : propertySources) {
            String sourceName = source.getName();
            
            // 获取配置值用于演示
            Object appDescription = source.getProperty("app.description");
            Object appSummary = source.getProperty("app.summary");
            
            // 跳过configurationProperties，因为它不是原始数据源，而是合并视图
            if (!"configurationProperties".equals(sourceName)) {
                System.out.printf("%2d. %-50s => app.description: %s%n", 
                    index++, 
                    sourceName,
                    appDescription != null ? "\"" + appDescription + "\"" : "null");
                if (appSummary != null) {
                    System.out.printf("    %-50s => app.summary: %s%n", 
                        "", 
                        "\"" + appSummary + "\"");
                }
            }
        }
        
        System.out.println("最终生效的配置值:");
        System.out.println("app.description: " + environment.getProperty("app.description"));
        System.out.println("app.summary: " + environment.getProperty("app.summary"));
    }
}