package com.example.configdemo.controller;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.HashMap;
import java.util.Map;

@RestController
public class ConfigController {

    @Value("${app.description:未设置}")
    private String appDescription;
    
    @Value("${app.summary:未设置}")
    private String appSummary;

    @GetMapping("/config")
    public Map<String, String> getConfig() {
        Map<String, String> result = new HashMap<>();
        result.put("app.description", appDescription);
        result.put("app.summary", appSummary);
        return result;
    }
}